//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
//+----------------+
#property indicator_buffers         2
#property indicator_plots           2
//+----------------+
#property indicator_type1           DRAW_LINE
#property indicator_color1          clrRed
#property indicator_style1          STYLE_SOLID
#property indicator_width1          2
//+----------------+
#property indicator_type2           DRAW_LINE
#property indicator_color2          clrBlue
#property indicator_style2          STYLE_SOLID
#property indicator_width2          2
//+------------------------------------------------------------------+
double   Buff_iMA_01[],
         Buff_iMA_02[];
int      Handle_01,
         Handle_02;
//+------------------------------------------------------------------+
int OnInit(void)
{
   SetIndexBuffer(0, Buff_iMA_01, INDICATOR_DATA);
   SetIndexBuffer(1, Buff_iMA_02, INDICATOR_DATA);

   if ((Handle_01 = iMA(NULL, NULL, 9, 0, MODE_EMA, _AppliedTo)) == INVALID_HANDLE)
   {
      Print("Could not start the indicator...");
      return INIT_FAILED;
   };
   if ((Handle_02 = iMA(NULL, NULL, 20, 0, MODE_SMA, _AppliedTo)) == INVALID_HANDLE)
   {
      Print("Could not start the indicator...");
      return INIT_FAILED;
   };

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
  	ArrayInitialize(Buff_iMA_01, EMPTY_VALUE);
  	ArrayInitialize(Buff_iMA_02, EMPTY_VALUE);

   CopyBuffer(Handle_01, 0, 0, 9, Buff_iMA_01);
   CopyBuffer(Handle_02, 0, 0, 20, Buff_iMA_02);

   return rates_total;
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   if (Handle_01 != INVALID_HANDLE) 
      IndicatorRelease(Handle_01);
   if (Handle_02 != INVALID_HANDLE) 
      IndicatorRelease(Handle_02);
};
//+------------------------------------------------------------------+